/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database;

import com.mckoi.database.DataTableDef;
import com.mckoi.database.IndexSet;
import com.mckoi.database.MasterTableDataSource;
import com.mckoi.database.MutableTableDataSource;
import com.mckoi.database.SequenceManager;
import com.mckoi.database.StatementException;
import com.mckoi.database.TableDataSource;
import com.mckoi.database.TableName;
import com.mckoi.database.TransactionSystem;
import com.mckoi.debug.DebugLogger;
import java.util.ArrayList;
import java.util.HashMap;

public abstract class SimpleTransaction {
    private TransactionSystem system;
    private ArrayList visible_tables;
    private ArrayList table_indices;
    private ArrayList cleanup_queue;
    private HashMap table_cache;
    private HashMap sequence_value_cache;
    private SequenceManager sequence_manager;
    private boolean read_only;

    SimpleTransaction(TransactionSystem system, SequenceManager sequence_manager) {
        this.system = system;
        this.visible_tables = new ArrayList();
        this.table_indices = new ArrayList();
        this.table_cache = new HashMap();
        this.sequence_value_cache = new HashMap();
        this.sequence_manager = sequence_manager;
        this.read_only = false;
    }

    public void setReadOnly() {
        this.read_only = true;
    }

    public boolean isReadOnly() {
        return this.read_only;
    }

    public final TransactionSystem getSystem() {
        return this.system;
    }

    protected final ArrayList getVisibleTables() {
        return this.visible_tables;
    }

    public final DebugLogger Debug() {
        return this.getSystem().Debug();
    }

    protected int getVisibleTableCount() {
        return this.visible_tables.size();
    }

    protected MasterTableDataSource getVisibleTable(int n) {
        return (MasterTableDataSource)this.visible_tables.get(n);
    }

    protected MasterTableDataSource findVisibleTable(TableName table_name, boolean ignore_case) {
        int size = this.visible_tables.size();
        for (int i = 0; i < size; ++i) {
            MasterTableDataSource master = (MasterTableDataSource)this.visible_tables.get(i);
            DataTableDef table_def = master.getDataTableDef();
            if (!(ignore_case ? table_def.getTableName().equalsIgnoreCase(table_name) : table_def.getTableName().equals(table_name))) continue;
            return master;
        }
        return null;
    }

    final IndexSet getIndexSetForTable(MasterTableDataSource table) {
        int sz = this.table_indices.size();
        for (int i = 0; i < sz; ++i) {
            if (this.visible_tables.get(i) != table) continue;
            return (IndexSet)this.table_indices.get(i);
        }
        throw new RuntimeException("MasterTableDataSource not found in this transaction.");
    }

    protected final void setIndexSetForTable(MasterTableDataSource table, IndexSet index_set) {
        int sz = this.table_indices.size();
        for (int i = 0; i < sz; ++i) {
            if (this.visible_tables.get(i) != table) continue;
            this.table_indices.set(i, index_set);
            return;
        }
        throw new RuntimeException("MasterTableDataSource not found in this transaction.");
    }

    protected boolean isDynamicTable(TableName table_name) {
        return false;
    }

    protected MutableTableDataSource getDynamicTable(TableName table_name) {
        throw new StatementException("Table '" + table_name + "' not found.");
    }

    protected DataTableDef getDynamicDataTableDef(TableName table_name) {
        throw new StatementException("Table '" + table_name + "' not found.");
    }

    protected String getDynamicTableType(TableName table_name) {
        throw new StatementException("Table '" + table_name + "' not found.");
    }

    protected TableName[] getDynamicTableList() {
        return new TableName[0];
    }

    abstract MutableTableDataSource createMutableTableDataSourceAtCommit(MasterTableDataSource var1);

    protected void flushTableCache(TableName table_name) {
        this.table_cache.remove(table_name);
    }

    void addVisibleTable(MasterTableDataSource table, IndexSet index_set) {
        if (this.isReadOnly()) {
            throw new RuntimeException("Transaction is read-only.");
        }
        this.visible_tables.add(table);
        this.table_indices.add(index_set);
    }

    void removeVisibleTable(MasterTableDataSource table) {
        if (this.isReadOnly()) {
            throw new RuntimeException("Transaction is read-only.");
        }
        int i = this.visible_tables.indexOf(table);
        if (i != -1) {
            this.visible_tables.remove(i);
            IndexSet index_set = (IndexSet)this.table_indices.remove(i);
            if (this.cleanup_queue == null) {
                this.cleanup_queue = new ArrayList();
            }
            this.cleanup_queue.add(table);
            this.cleanup_queue.add(index_set);
            TableName table_name = table.getTableName();
            this.table_cache.remove(table_name);
        }
    }

    void updateVisibleTable(MasterTableDataSource table, IndexSet index_set) {
        if (this.isReadOnly()) {
            throw new RuntimeException("Transaction is read-only.");
        }
        this.removeVisibleTable(table);
        this.addVisibleTable(table, index_set);
    }

    protected void disposeAllIndices() {
        int i;
        try {
            for (i = 0; i < this.table_indices.size(); ++i) {
                ((IndexSet)this.table_indices.get(i)).dispose();
            }
        }
        catch (Throwable e) {
            this.Debug().writeException(e);
        }
        try {
            if (this.cleanup_queue != null) {
                for (i = 0; i < this.cleanup_queue.size(); i += 2) {
                    MasterTableDataSource master = (MasterTableDataSource)this.cleanup_queue.get(i);
                    IndexSet index_set = (IndexSet)this.cleanup_queue.get(i + 1);
                    index_set.dispose();
                }
                this.cleanup_queue = null;
            }
        }
        catch (Throwable e) {
            this.Debug().writeException(e);
        }
    }

    public TableDataSource getTableDataSource(TableName table_name) {
        return this.getTable(table_name);
    }

    public MutableTableDataSource getTable(TableName table_name) {
        MutableTableDataSource table = (MutableTableDataSource)this.table_cache.get(table_name);
        if (table != null) {
            return table;
        }
        MasterTableDataSource master = this.findVisibleTable(table_name, false);
        if (master == null) {
            if (this.isDynamicTable(table_name)) {
                return this.getDynamicTable(table_name);
            }
        } else {
            table = this.createMutableTableDataSourceAtCommit(master);
            this.table_cache.put(table_name, table);
        }
        return table;
    }

    public DataTableDef getDataTableDef(TableName table_name) {
        if (this.isDynamicTable(table_name)) {
            return this.getDynamicDataTableDef(table_name);
        }
        int sz = this.visible_tables.size();
        for (int i = 0; i < sz; ++i) {
            MasterTableDataSource master = (MasterTableDataSource)this.visible_tables.get(i);
            DataTableDef table_def = master.getDataTableDef();
            if (!table_def.getTableName().equals(table_name)) continue;
            return table_def;
        }
        return null;
    }

    public TableName[] getTableList() {
        int i;
        TableName[] internal_tables = this.getDynamicTableList();
        int sz = this.visible_tables.size();
        TableName[] tables = new TableName[sz + internal_tables.length];
        for (i = 0; i < sz; ++i) {
            MasterTableDataSource master = (MasterTableDataSource)this.visible_tables.get(i);
            DataTableDef table_def = master.getDataTableDef();
            tables[i] = new TableName(table_def.getSchema(), table_def.getName());
        }
        for (i = 0; i < internal_tables.length; ++i) {
            tables[sz + i] = internal_tables[i];
        }
        return tables;
    }

    public boolean tableExists(TableName table_name) {
        return this.isDynamicTable(table_name) || this.realTableExists(table_name);
    }

    final boolean realTableExists(TableName table_name) {
        return this.findVisibleTable(table_name, false) != null;
    }

    public TableName tryResolveCase(TableName table_name) {
        MasterTableDataSource table = this.findVisibleTable(table_name, true);
        if (table != null) {
            return table.getTableName();
        }
        String tschema = table_name.getSchema();
        String tname = table_name.getName();
        TableName[] list = this.getDynamicTableList();
        for (int i = 0; i < list.length; ++i) {
            TableName ctable = list[i];
            if (!ctable.getSchema().equalsIgnoreCase(tschema) || !ctable.getName().equalsIgnoreCase(tname)) continue;
            return ctable;
        }
        return table_name;
    }

    public String getTableType(TableName table_name) {
        if (this.isDynamicTable(table_name)) {
            return this.getDynamicTableType(table_name);
        }
        if (this.findVisibleTable(table_name, false) != null) {
            return "TABLE";
        }
        throw new RuntimeException("No table '" + table_name + "' to report type for.");
    }

    public TableName resolveToTableName(String current_schema, String name, boolean case_insensitive) {
        TableName table_name = TableName.resolve(current_schema, name);
        TableName[] tables = this.getTableList();
        TableName found = null;
        for (int i = 0; i < tables.length; ++i) {
            boolean match = case_insensitive ? tables[i].equalsIgnoreCase(table_name) : tables[i].equals(table_name);
            if (!match) continue;
            if (found != null) {
                throw new StatementException("Ambiguous reference: " + name);
            }
            found = tables[i];
        }
        if (found == null) {
            throw new StatementException("Object not found: " + name);
        }
        return found;
    }

    void flushSequenceManager(TableName name) {
        this.sequence_manager.flushGenerator(name);
    }

    public long nextSequenceValue(TableName name) {
        if (this.isReadOnly()) {
            throw new RuntimeException("Sequence operation not permitted for read only transaction.");
        }
        if (this.sequence_manager == null) {
            throw new RuntimeException("Sequence operations are not permitted.");
        }
        SequenceManager seq = this.sequence_manager;
        long val = seq.nextValue(this, name);
        this.sequence_value_cache.put(name, new Long(val));
        return val;
    }

    public long lastSequenceValue(TableName name) {
        Long v = (Long)this.sequence_value_cache.get(name);
        if (v != null) {
            return v;
        }
        throw new StatementException("Current value for sequence generator " + name + " is not available.");
    }

    public void setSequenceValue(TableName name, long value) {
        if (this.isReadOnly()) {
            throw new RuntimeException("Sequence operation not permitted for read only transaction.");
        }
        if (this.sequence_manager == null) {
            throw new RuntimeException("Sequence operations are not permitted.");
        }
        SequenceManager seq = this.sequence_manager;
        seq.setValue(this, name, value);
        this.sequence_value_cache.put(name, new Long(value));
    }

    public long currentUniqueID(TableName table_name) {
        MasterTableDataSource master = this.findVisibleTable(table_name, false);
        if (master == null) {
            throw new StatementException("Table with name '" + table_name + "' could not be " + "found to retrieve unique id.");
        }
        return master.currentUniqueID();
    }

    public long nextUniqueID(TableName table_name) {
        if (this.isReadOnly()) {
            throw new RuntimeException("Sequence operation not permitted for read only transaction.");
        }
        MasterTableDataSource master = this.findVisibleTable(table_name, false);
        if (master == null) {
            throw new StatementException("Table with name '" + table_name + "' could not be " + "found to retrieve unique id.");
        }
        return master.nextUniqueID();
    }

    public void setUniqueID(TableName table_name, long unique_id) {
        if (this.isReadOnly()) {
            throw new RuntimeException("Sequence operation not permitted for read only transaction.");
        }
        MasterTableDataSource master = this.findVisibleTable(table_name, false);
        if (master == null) {
            throw new StatementException("Table with name '" + table_name + "' could not be " + "found to set unique id.");
        }
        master.setUniqueID(unique_id);
    }
}

